--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A ConfigVariable fetches a json file from a given path and stores the variable in the id field in that file. If no config file of that name exists yet, it will create it.
--- 
--- The ConfigVariable saves to the config file every time the setting is updated. It is generally recommended you use TableVariable and save the config using `template.saveOnClose()` instead, especially if you are using a setting where updates happen frequently such as with sliders.
--- @class mwseMCMConfigVariable : mwseMCMVariable
--- @field defaultSetting unknown If there is no value stored by the `id` key in the config file, it will be initialized to this value.
--- @field id string Key in the config file used to store the variable.
--- @field path string Location of the config file relative to Data `Files/MWSE/config/`.
mwseMCMConfigVariable = {}

--- Creates a new variable of this type.
--- @param variable mwseMCMConfigVariable.new.variable This table accepts the following values:
--- 
--- `id`: string — Key in the config file used to store the variable.
--- 
--- `path`: string — Location of the config file relative to Data `Files/MWSE/config/`.
--- 
--- `defaultSetting?`: unknown — *Optional*. If there is no value stored by the `id` key in the config file, it will be initialized to this value.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. If true, the setting containing this variable will be disabled if the game is on main menu.
--- 
--- `numbersOnly?`: boolean — *Default*: `false`. If true, only numbers will be allowed for this variable in TextFields.
--- 
--- `restartRequired?`: boolean — *Default*: `false`. If true, updating the setting containing this variable will notify the player to restart the game.
--- 
--- `restartRequiredMessage?`: string — *Optional*.  The default text is a localized version of: "The game must be restarted before this change will come into effect.".
--- 
--- `converter?`: fun(newValue): unknown — *Optional*. This function is called when the value of the variable is changed. The function can modify the new value before it is saved.
--- @return mwseMCMConfigVariable variable No description yet available.
function mwseMCMConfigVariable:new(variable) end

---Table parameter definitions for `mwseMCMConfigVariable.new`.
--- @class mwseMCMConfigVariable.new.variable
--- @field id string Key in the config file used to store the variable.
--- @field path string Location of the config file relative to Data `Files/MWSE/config/`.
--- @field defaultSetting? unknown *Optional*. If there is no value stored by the `id` key in the config file, it will be initialized to this value.
--- @field inGameOnly? boolean *Default*: `false`. If true, the setting containing this variable will be disabled if the game is on main menu.
--- @field numbersOnly? boolean *Default*: `false`. If true, only numbers will be allowed for this variable in TextFields.
--- @field restartRequired? boolean *Default*: `false`. If true, updating the setting containing this variable will notify the player to restart the game.
--- @field restartRequiredMessage? string *Optional*.  The default text is a localized version of: "The game must be restarted before this change will come into effect.".
--- @field converter? fun(newValue): unknown *Optional*. This function is called when the value of the variable is changed. The function can modify the new value before it is saved.

